<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name'                      => ['required', 'string', 'min:3', 'max:255'],
            'email'                     => ['required', 'string', 'email'],
            'password'                  => ['required', 'min:8'],
            'password-baru'             => ['required', 'min:8'],
            'password-confirmation'     => ['required', 'same:password-baru'],
            'deskripsi'                 => ['required',  'string', 'min:10'],
            'avatar'                    => ['required', 'image', 'mimes:jpeg,png,jpg,gif', 'max:1048']
        ];
    }
}
